/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.Macro;
import com.inprise.vbroker.util.StringFunctions;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class FunctionalMacro
extends Macro {
    private static final boolean Trace = false;
    private boolean Builtin;
    private int NumArgs;
    private int poundCount;
    private Vector ReplacementParts = new Vector();
    private StringBuffer Strbuf = new StringBuffer(128);

    FunctionalMacro(String name, String definedInFileName, long definedAtLine, int numArgs, boolean builtin) {
        super(name, definedInFileName, definedAtLine);
        this.Builtin = builtin;
        this.NumArgs = numArgs;
        if (!this.Builtin) {
            this.concatLiteral(" ");
        }
    }

    void addFormal(int argNum) {
        ++argNum;
        if (this.poundCount < 2) {
            this.concatLiteral(" ");
        }
        if (this.poundCount == 1 || this.poundCount == 3) {
            this.ReplacementParts.addElement(new Integer(-argNum));
        } else {
            this.ReplacementParts.addElement(new Integer(argNum));
        }
        if (this.poundCount < 2) {
            this.concatLiteral(" ");
        }
        this.poundCount = 0;
    }

    String addLiteralString(String text) {
        String ret = null;
        if (this.poundCount == 1 || this.poundCount == 3) {
            ret = "MacroDef.cantStringizeNonArgToken";
        }
        this.concatLiteral(text);
        this.poundCount = 0;
        return ret;
    }

    private void coerceNumberOfActualsTo(Vector args) {
        if (args.size() != this.NumArgs) {
            args.setSize(this.NumArgs);
            for (int i = this.NumArgs - args.size(); i >= 0 && i < this.NumArgs; ++i) {
                args.setElementAt("", i);
            }
        }
    }

    private void concatLiteral(String str) {
        if (str.equals("")) {
            return;
        }
        if (this.ReplacementParts.size() == 0) {
            this.ReplacementParts.addElement(str);
            return;
        }
        Object obj = this.ReplacementParts.lastElement();
        if (obj instanceof String) {
            String prev = (String)obj;
            this.ReplacementParts.setElementAt(String.valueOf(prev).concat(String.valueOf(str)), this.ReplacementParts.size() - 1);
        } else {
            this.ReplacementParts.addElement(str);
        }
    }

    boolean equals(Macro macro) {
        if (!(macro instanceof FunctionalMacro)) {
            return false;
        }
        FunctionalMacro other = (FunctionalMacro)macro;
        if (this.ReplacementParts.size() != other.ReplacementParts.size()) {
            return false;
        }
        for (int i = 0; i < this.ReplacementParts.size(); ++i) {
            if (this.ReplacementParts.elementAt(i).equals(other.ReplacementParts.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    String finishDefinition() {
        String ret = null;
        if (this.poundCount > 0) {
            ret = "MacroDef.poundsAtEnd";
        }
        this.concatLiteral(" ");
        return ret;
    }

    boolean isBuiltin() {
        return this.Builtin;
    }

    boolean isFunctional() {
        return true;
    }

    boolean isSimple() {
        return false;
    }

    int numArgs() {
        return this.NumArgs;
    }

    String processPound() {
        String ret = null;
        if (++this.poundCount > 3) {
            ret = "MacroDef.tooManyPounds";
            this.poundCount = 0;
        }
        if (this.poundCount == 2) {
            int len;
            Object maybeInt;
            if (this.ReplacementParts.size() == 1 && this.ReplacementParts.elementAt(0) instanceof String && ((String)this.ReplacementParts.elementAt(0)).equals(" ")) {
                ret = "MacroDef.concatAtStart";
                this.poundCount = 0;
            } else if (this.ReplacementParts.size() >= 4 && (maybeInt = this.ReplacementParts.elementAt((len = this.ReplacementParts.size()) - 2)) instanceof Integer) {
                this.ReplacementParts.removeElementAt(len - 1);
            }
        }
        return ret;
    }

    byte[] value(Vector actualArgs) {
        if (this.Builtin) {
            return null;
        }
        this.coerceNumberOfActualsTo(actualArgs);
        this.Strbuf.setLength(0);
        for (int i = 0; i < this.ReplacementParts.size(); ++i) {
            Object obj = this.ReplacementParts.elementAt(i);
            if (obj instanceof String) {
                this.Strbuf.append(obj);
                continue;
            }
            int argNum = (Integer)obj;
            if (argNum >= 0) {
                this.Strbuf.append((String)actualArgs.elementAt(argNum - 1));
                continue;
            }
            this.Strbuf.append(StringFunctions.stringize((String)actualArgs.elementAt(-argNum - 1), false, true));
        }
        byte[] ret = null;
        try {
            ret = this.Strbuf.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }
}

